<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Schedule;

class ScheduleController extends Controller
{
    public function index() {
        $courses = [
            'Database' => 'Sir Ahmad',
            'Web Development' => 'Sir Nabeel',
            'Information Technology' => 'Sir Ahmad',
            'Business Administrator' => 'Sir Adnan',
            'Math' => 'Mam Haleema',
            'Calculus Math' => 'Sir Farooq',
            'C++' => 'Sir Falak',
            'HRM' => 'Sir Ammar',
            'Software Engineering' => 'Mam Kashifa',
        ];
        $schedules = Schedule::all();
        return view('schedule', compact('courses', 'schedules'));
    }

    public function store(Request $request) {
        Schedule::create($request->all());
        return redirect('/schedule')->with('success', 'Schedule saved!');
    }

    public function getFaculty($course) {
        $faculties = [
            'Database' => 'Sir Ahmad',
            'Web Development' => 'Sir Nabeel',
            'Information Technology' => 'Sir Ahmad',
            'Business Administrator' => 'Sir Adnan',
            'Math' => 'Mam Haleema',
            'Calculus Math' => 'Sir Farooq',
            'C++' => 'Sir Falak',
            'HRM' => 'Sir Ammar',
            'Software Engineering' => 'Mam Kashifa',
        ];
        return response()->json(['faculty' => $faculties[$course] ?? '']);
    }
}
