<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Schedule Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <style>
        body {
            background-color: #0f172a;
            color: #fff;
        }
        .form-label, .table th, .table td {
            color: #fff;
        }
        .form-control, .form-select {
            background-color: #1e293b;
            border-color: #334155;
            color: #fff;
        }
        .form-control:focus, .form-select:focus {
            background-color: #1e293b;
            color: #fff;
            border-color: #38bdf8;
            box-shadow: none;
        }
        .table thead {
            background-color: #38bdf8;
            color: #000;
        }
    </style>
</head>
<body>

<div class="container py-5">
    <h2 class="mb-4 text-info">📅 Schedule Management</h2>

    <form action="/schedule" method="POST" class="row g-3">
        @csrf
        <div class="col-md-3">
            <label class="form-label">Date</label>
            <input type="date" name="date" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Day</label>
            <input type="text" name="day" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Course</label>
            <select name="course" class="form-select" id="courseSelect">
                <option value="">Select Course</option>
                @foreach($courses as $course => $faculty)
                    <option value="{{ $course }}">{{ $course }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Faculty</label>
            <select name="faculty" class="form-select" id="facultySelect">
                <option value="">Select Faculty</option>
                @foreach(array_unique(array_values($courses)) as $faculty)
                    <option value="{{ $faculty }}">{{ $faculty }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label">Subject</label>
            <input type="text" name="subject" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Start Time</label>
            <input type="time" name="start_time" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">End Time</label>
            <input type="time" name="end_time" class="form-control">
        </div>
        <div class="col-12">
            <button type="submit" class="btn btn-info">💾 Save Schedule</button>
        </div>
    </form>

    <h3 class="mt-5 text-info">📌 Current Schedules</h3>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Date</th>
                <th>Day</th>
                <th>Course</th>
                <th>Faculty</th>
                <th>Subject</th>
                <th>Start</th>
                <th>End</th>
            </tr>
        </thead>
        <tbody>
            @foreach($schedules as $s)
                <tr>
                    <td>{{ $s->date }}</td>
                    <td>{{ $s->day }}</td>
                    <td>{{ $s->course }}</td>
                    <td>{{ $s->faculty }}</td>
                    <td>{{ $s->subject }}</td>
                    <td>{{ $s->start_time }}</td>
                    <td>{{ $s->end_time }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script>
    $('#courseSelect').change(function () {
        let course = $(this).val();
        if (course) {
            $.get('/get-faculty/' + course, function (data) {
                $('#facultySelect').val(data.faculty);
            });
        }
    });
</script>

</body>
</html>
